/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentHealth;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentHealthStatus;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentLink;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentResourcesDescription;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentStatus;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class EnvironmentDescription
implements Serializable,
Cloneable {
    private String environmentName;
    private String environmentId;
    private String applicationName;
    private String versionLabel;
    private String solutionStackName;
    private String platformArn;
    private String templateName;
    private String description;
    private String endpointURL;
    private String cNAME;
    private Date dateCreated;
    private Date dateUpdated;
    private String status;
    private Boolean abortableOperationInProgress;
    private String health;
    private String healthStatus;
    private EnvironmentResourcesDescription resources;
    private EnvironmentTier tier;
    private SdkInternalList<EnvironmentLink> environmentLinks;

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public EnvironmentDescription withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public EnvironmentDescription withEnvironmentId(String environmentId) {
        this.setEnvironmentId(environmentId);
        return this;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public EnvironmentDescription withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public EnvironmentDescription withVersionLabel(String versionLabel) {
        this.setVersionLabel(versionLabel);
        return this;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public EnvironmentDescription withSolutionStackName(String solutionStackName) {
        this.setSolutionStackName(solutionStackName);
        return this;
    }

    public void setPlatformArn(String platformArn) {
        this.platformArn = platformArn;
    }

    public String getPlatformArn() {
        return this.platformArn;
    }

    public EnvironmentDescription withPlatformArn(String platformArn) {
        this.setPlatformArn(platformArn);
        return this;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public EnvironmentDescription withTemplateName(String templateName) {
        this.setTemplateName(templateName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public EnvironmentDescription withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public EnvironmentDescription withEndpointURL(String endpointURL) {
        this.setEndpointURL(endpointURL);
        return this;
    }

    public void setCNAME(String cNAME) {
        this.cNAME = cNAME;
    }

    public String getCNAME() {
        return this.cNAME;
    }

    public EnvironmentDescription withCNAME(String cNAME) {
        this.setCNAME(cNAME);
        return this;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public EnvironmentDescription withDateCreated(Date dateCreated) {
        this.setDateCreated(dateCreated);
        return this;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public EnvironmentDescription withDateUpdated(Date dateUpdated) {
        this.setDateUpdated(dateUpdated);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public EnvironmentDescription withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(EnvironmentStatus status) {
        this.status = status.toString();
    }

    public EnvironmentDescription withStatus(EnvironmentStatus status) {
        this.setStatus(status);
        return this;
    }

    public void setAbortableOperationInProgress(Boolean abortableOperationInProgress) {
        this.abortableOperationInProgress = abortableOperationInProgress;
    }

    public Boolean getAbortableOperationInProgress() {
        return this.abortableOperationInProgress;
    }

    public EnvironmentDescription withAbortableOperationInProgress(Boolean abortableOperationInProgress) {
        this.setAbortableOperationInProgress(abortableOperationInProgress);
        return this;
    }

    public Boolean isAbortableOperationInProgress() {
        return this.abortableOperationInProgress;
    }

    public void setHealth(String health) {
        this.health = health;
    }

    public String getHealth() {
        return this.health;
    }

    public EnvironmentDescription withHealth(String health) {
        this.setHealth(health);
        return this;
    }

    @JsonIgnore
    public void setHealth(EnvironmentHealth health) {
        this.health = health.toString();
    }

    public EnvironmentDescription withHealth(EnvironmentHealth health) {
        this.setHealth(health);
        return this;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public EnvironmentDescription withHealthStatus(String healthStatus) {
        this.setHealthStatus(healthStatus);
        return this;
    }

    @JsonIgnore
    public void setHealthStatus(EnvironmentHealthStatus healthStatus) {
        this.healthStatus = healthStatus.toString();
    }

    public EnvironmentDescription withHealthStatus(EnvironmentHealthStatus healthStatus) {
        this.setHealthStatus(healthStatus);
        return this;
    }

    public void setResources(EnvironmentResourcesDescription resources) {
        this.resources = resources;
    }

    public EnvironmentResourcesDescription getResources() {
        return this.resources;
    }

    public EnvironmentDescription withResources(EnvironmentResourcesDescription resources) {
        this.setResources(resources);
        return this;
    }

    public void setTier(EnvironmentTier tier) {
        this.tier = tier;
    }

    public EnvironmentTier getTier() {
        return this.tier;
    }

    public EnvironmentDescription withTier(EnvironmentTier tier) {
        this.setTier(tier);
        return this;
    }

    public List<EnvironmentLink> getEnvironmentLinks() {
        if (this.environmentLinks == null) {
            this.environmentLinks = new SdkInternalList();
        }
        return this.environmentLinks;
    }

    public void setEnvironmentLinks(Collection<EnvironmentLink> environmentLinks) {
        if (environmentLinks == null) {
            this.environmentLinks = null;
            return;
        }
        this.environmentLinks = new SdkInternalList<EnvironmentLink>(environmentLinks);
    }

    public EnvironmentDescription withEnvironmentLinks(EnvironmentLink ... environmentLinks) {
        if (this.environmentLinks == null) {
            this.setEnvironmentLinks(new SdkInternalList<EnvironmentLink>(environmentLinks.length));
        }
        for (EnvironmentLink ele : environmentLinks) {
            this.environmentLinks.add(ele);
        }
        return this;
    }

    public EnvironmentDescription withEnvironmentLinks(Collection<EnvironmentLink> environmentLinks) {
        this.setEnvironmentLinks(environmentLinks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getEnvironmentId() != null) {
            sb.append("EnvironmentId: ").append(this.getEnvironmentId()).append(",");
        }
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getVersionLabel() != null) {
            sb.append("VersionLabel: ").append(this.getVersionLabel()).append(",");
        }
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.getSolutionStackName()).append(",");
        }
        if (this.getPlatformArn() != null) {
            sb.append("PlatformArn: ").append(this.getPlatformArn()).append(",");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: ").append(this.getTemplateName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEndpointURL() != null) {
            sb.append("EndpointURL: ").append(this.getEndpointURL()).append(",");
        }
        if (this.getCNAME() != null) {
            sb.append("CNAME: ").append(this.getCNAME()).append(",");
        }
        if (this.getDateCreated() != null) {
            sb.append("DateCreated: ").append(this.getDateCreated()).append(",");
        }
        if (this.getDateUpdated() != null) {
            sb.append("DateUpdated: ").append(this.getDateUpdated()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAbortableOperationInProgress() != null) {
            sb.append("AbortableOperationInProgress: ").append(this.getAbortableOperationInProgress()).append(",");
        }
        if (this.getHealth() != null) {
            sb.append("Health: ").append(this.getHealth()).append(",");
        }
        if (this.getHealthStatus() != null) {
            sb.append("HealthStatus: ").append(this.getHealthStatus()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier()).append(",");
        }
        if (this.getEnvironmentLinks() != null) {
            sb.append("EnvironmentLinks: ").append(this.getEnvironmentLinks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentDescription)) {
            return false;
        }
        EnvironmentDescription other = (EnvironmentDescription)obj;
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null) {
            return false;
        }
        if (other.getEnvironmentId() != null && !other.getEnvironmentId().equals(this.getEnvironmentId())) {
            return false;
        }
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null) {
            return false;
        }
        if (other.getVersionLabel() != null && !other.getVersionLabel().equals(this.getVersionLabel())) {
            return false;
        }
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getPlatformArn() == null ^ this.getPlatformArn() == null) {
            return false;
        }
        if (other.getPlatformArn() != null && !other.getPlatformArn().equals(this.getPlatformArn())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEndpointURL() == null ^ this.getEndpointURL() == null) {
            return false;
        }
        if (other.getEndpointURL() != null && !other.getEndpointURL().equals(this.getEndpointURL())) {
            return false;
        }
        if (other.getCNAME() == null ^ this.getCNAME() == null) {
            return false;
        }
        if (other.getCNAME() != null && !other.getCNAME().equals(this.getCNAME())) {
            return false;
        }
        if (other.getDateCreated() == null ^ this.getDateCreated() == null) {
            return false;
        }
        if (other.getDateCreated() != null && !other.getDateCreated().equals(this.getDateCreated())) {
            return false;
        }
        if (other.getDateUpdated() == null ^ this.getDateUpdated() == null) {
            return false;
        }
        if (other.getDateUpdated() != null && !other.getDateUpdated().equals(this.getDateUpdated())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAbortableOperationInProgress() == null ^ this.getAbortableOperationInProgress() == null) {
            return false;
        }
        if (other.getAbortableOperationInProgress() != null && !other.getAbortableOperationInProgress().equals(this.getAbortableOperationInProgress())) {
            return false;
        }
        if (other.getHealth() == null ^ this.getHealth() == null) {
            return false;
        }
        if (other.getHealth() != null && !other.getHealth().equals(this.getHealth())) {
            return false;
        }
        if (other.getHealthStatus() == null ^ this.getHealthStatus() == null) {
            return false;
        }
        if (other.getHealthStatus() != null && !other.getHealthStatus().equals(this.getHealthStatus())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        if (other.getTier() != null && !other.getTier().equals(this.getTier())) {
            return false;
        }
        if (other.getEnvironmentLinks() == null ^ this.getEnvironmentLinks() == null) {
            return false;
        }
        return other.getEnvironmentLinks() == null || other.getEnvironmentLinks().equals(this.getEnvironmentLinks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentId() == null ? 0 : this.getEnvironmentId().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabel() == null ? 0 : this.getVersionLabel().hashCode());
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformArn() == null ? 0 : this.getPlatformArn().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointURL() == null ? 0 : this.getEndpointURL().hashCode());
        hashCode = 31 * hashCode + (this.getCNAME() == null ? 0 : this.getCNAME().hashCode());
        hashCode = 31 * hashCode + (this.getDateCreated() == null ? 0 : this.getDateCreated().hashCode());
        hashCode = 31 * hashCode + (this.getDateUpdated() == null ? 0 : this.getDateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAbortableOperationInProgress() == null ? 0 : this.getAbortableOperationInProgress().hashCode());
        hashCode = 31 * hashCode + (this.getHealth() == null ? 0 : this.getHealth().hashCode());
        hashCode = 31 * hashCode + (this.getHealthStatus() == null ? 0 : this.getHealthStatus().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentLinks() == null ? 0 : this.getEnvironmentLinks().hashCode());
        return hashCode;
    }

    public EnvironmentDescription clone() {
        try {
            return (EnvironmentDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

