/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.NetworkMode;
import com.amazonaws.services.ecs.model.TaskDefinitionPlacementConstraint;
import com.amazonaws.services.ecs.model.TaskDefinitionStatus;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.transform.TaskDefinitionMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TaskDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String taskDefinitionArn;
    private SdkInternalList<ContainerDefinition> containerDefinitions;
    private String family;
    private String taskRoleArn;
    private String networkMode;
    private Integer revision;
    private SdkInternalList<Volume> volumes;
    private String status;
    private SdkInternalList<Attribute> requiresAttributes;
    private SdkInternalList<TaskDefinitionPlacementConstraint> placementConstraints;

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public TaskDefinition withTaskDefinitionArn(String taskDefinitionArn) {
        this.setTaskDefinitionArn(taskDefinitionArn);
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        if (this.containerDefinitions == null) {
            this.containerDefinitions = new SdkInternalList();
        }
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        this.containerDefinitions = new SdkInternalList<ContainerDefinition>(containerDefinitions);
    }

    public TaskDefinition withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.containerDefinitions == null) {
            this.setContainerDefinitions(new SdkInternalList<ContainerDefinition>(containerDefinitions.length));
        }
        for (ContainerDefinition ele : containerDefinitions) {
            this.containerDefinitions.add(ele);
        }
        return this;
    }

    public TaskDefinition withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        this.setContainerDefinitions(containerDefinitions);
        return this;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getFamily() {
        return this.family;
    }

    public TaskDefinition withFamily(String family) {
        this.setFamily(family);
        return this;
    }

    public void setTaskRoleArn(String taskRoleArn) {
        this.taskRoleArn = taskRoleArn;
    }

    public String getTaskRoleArn() {
        return this.taskRoleArn;
    }

    public TaskDefinition withTaskRoleArn(String taskRoleArn) {
        this.setTaskRoleArn(taskRoleArn);
        return this;
    }

    public void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public TaskDefinition withNetworkMode(String networkMode) {
        this.setNetworkMode(networkMode);
        return this;
    }

    @JsonIgnore
    public void setNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode.toString();
    }

    public TaskDefinition withNetworkMode(NetworkMode networkMode) {
        this.setNetworkMode(networkMode);
        return this;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public TaskDefinition withRevision(Integer revision) {
        this.setRevision(revision);
        return this;
    }

    public List<Volume> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new SdkInternalList();
        }
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new SdkInternalList<Volume>(volumes);
    }

    public TaskDefinition withVolumes(Volume ... volumes) {
        if (this.volumes == null) {
            this.setVolumes(new SdkInternalList<Volume>(volumes.length));
        }
        for (Volume ele : volumes) {
            this.volumes.add(ele);
        }
        return this;
    }

    public TaskDefinition withVolumes(Collection<Volume> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public TaskDefinition withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(TaskDefinitionStatus status) {
        this.status = status.toString();
    }

    public TaskDefinition withStatus(TaskDefinitionStatus status) {
        this.setStatus(status);
        return this;
    }

    public List<Attribute> getRequiresAttributes() {
        if (this.requiresAttributes == null) {
            this.requiresAttributes = new SdkInternalList();
        }
        return this.requiresAttributes;
    }

    public void setRequiresAttributes(Collection<Attribute> requiresAttributes) {
        if (requiresAttributes == null) {
            this.requiresAttributes = null;
            return;
        }
        this.requiresAttributes = new SdkInternalList<Attribute>(requiresAttributes);
    }

    public TaskDefinition withRequiresAttributes(Attribute ... requiresAttributes) {
        if (this.requiresAttributes == null) {
            this.setRequiresAttributes(new SdkInternalList<Attribute>(requiresAttributes.length));
        }
        for (Attribute ele : requiresAttributes) {
            this.requiresAttributes.add(ele);
        }
        return this;
    }

    public TaskDefinition withRequiresAttributes(Collection<Attribute> requiresAttributes) {
        this.setRequiresAttributes(requiresAttributes);
        return this;
    }

    public List<TaskDefinitionPlacementConstraint> getPlacementConstraints() {
        if (this.placementConstraints == null) {
            this.placementConstraints = new SdkInternalList();
        }
        return this.placementConstraints;
    }

    public void setPlacementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
        if (placementConstraints == null) {
            this.placementConstraints = null;
            return;
        }
        this.placementConstraints = new SdkInternalList<TaskDefinitionPlacementConstraint>(placementConstraints);
    }

    public TaskDefinition withPlacementConstraints(TaskDefinitionPlacementConstraint ... placementConstraints) {
        if (this.placementConstraints == null) {
            this.setPlacementConstraints(new SdkInternalList<TaskDefinitionPlacementConstraint>(placementConstraints.length));
        }
        for (TaskDefinitionPlacementConstraint ele : placementConstraints) {
            this.placementConstraints.add(ele);
        }
        return this;
    }

    public TaskDefinition withPlacementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
        this.setPlacementConstraints(placementConstraints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskDefinitionArn() != null) {
            sb.append("TaskDefinitionArn: ").append(this.getTaskDefinitionArn()).append(",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: ").append(this.getContainerDefinitions()).append(",");
        }
        if (this.getFamily() != null) {
            sb.append("Family: ").append(this.getFamily()).append(",");
        }
        if (this.getTaskRoleArn() != null) {
            sb.append("TaskRoleArn: ").append(this.getTaskRoleArn()).append(",");
        }
        if (this.getNetworkMode() != null) {
            sb.append("NetworkMode: ").append(this.getNetworkMode()).append(",");
        }
        if (this.getRevision() != null) {
            sb.append("Revision: ").append(this.getRevision()).append(",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getRequiresAttributes() != null) {
            sb.append("RequiresAttributes: ").append(this.getRequiresAttributes()).append(",");
        }
        if (this.getPlacementConstraints() != null) {
            sb.append("PlacementConstraints: ").append(this.getPlacementConstraints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskDefinition)) {
            return false;
        }
        TaskDefinition other = (TaskDefinition)obj;
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null) {
            return false;
        }
        if (other.getTaskDefinitionArn() != null && !other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getFamily() == null ^ this.getFamily() == null) {
            return false;
        }
        if (other.getFamily() != null && !other.getFamily().equals(this.getFamily())) {
            return false;
        }
        if (other.getTaskRoleArn() == null ^ this.getTaskRoleArn() == null) {
            return false;
        }
        if (other.getTaskRoleArn() != null && !other.getTaskRoleArn().equals(this.getTaskRoleArn())) {
            return false;
        }
        if (other.getNetworkMode() == null ^ this.getNetworkMode() == null) {
            return false;
        }
        if (other.getNetworkMode() != null && !other.getNetworkMode().equals(this.getNetworkMode())) {
            return false;
        }
        if (other.getRevision() == null ^ this.getRevision() == null) {
            return false;
        }
        if (other.getRevision() != null && !other.getRevision().equals(this.getRevision())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getRequiresAttributes() == null ^ this.getRequiresAttributes() == null) {
            return false;
        }
        if (other.getRequiresAttributes() != null && !other.getRequiresAttributes().equals(this.getRequiresAttributes())) {
            return false;
        }
        if (other.getPlacementConstraints() == null ^ this.getPlacementConstraints() == null) {
            return false;
        }
        return other.getPlacementConstraints() == null || other.getPlacementConstraints().equals(this.getPlacementConstraints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskDefinitionArn() == null ? 0 : this.getTaskDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getFamily() == null ? 0 : this.getFamily().hashCode());
        hashCode = 31 * hashCode + (this.getTaskRoleArn() == null ? 0 : this.getTaskRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkMode() == null ? 0 : this.getNetworkMode().hashCode());
        hashCode = 31 * hashCode + (this.getRevision() == null ? 0 : this.getRevision().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRequiresAttributes() == null ? 0 : this.getRequiresAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementConstraints() == null ? 0 : this.getPlacementConstraints().hashCode());
        return hashCode;
    }

    public TaskDefinition clone() {
        try {
            return (TaskDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

