/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest;
import com.amazonaws.services.route53.model.VPC;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class DisassociateVPCFromHostedZoneRequestMarshaller
implements Marshaller<Request<DisassociateVPCFromHostedZoneRequest>, DisassociateVPCFromHostedZoneRequest> {
    @Override
    public Request<DisassociateVPCFromHostedZoneRequest> marshall(DisassociateVPCFromHostedZoneRequest disassociateVPCFromHostedZoneRequest) {
        if (disassociateVPCFromHostedZoneRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisassociateVPCFromHostedZoneRequest> request = new DefaultRequest<DisassociateVPCFromHostedZoneRequest>(disassociateVPCFromHostedZoneRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/disassociatevpc";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", disassociateVPCFromHostedZoneRequest.getHostedZoneId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("DisassociateVPCFromHostedZoneRequest");
            if (disassociateVPCFromHostedZoneRequest != null) {
                VPC vPC = disassociateVPCFromHostedZoneRequest.getVPC();
                if (vPC != null) {
                    xmlWriter.startElement("VPC");
                    if (vPC.getVPCRegion() != null) {
                        xmlWriter.startElement("VPCRegion").value(vPC.getVPCRegion()).endElement();
                    }
                    if (vPC.getVPCId() != null) {
                        xmlWriter.startElement("VPCId").value(vPC.getVPCId()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (disassociateVPCFromHostedZoneRequest.getComment() != null) {
                    xmlWriter.startElement("Comment").value(disassociateVPCFromHostedZoneRequest.getComment()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

