/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.DirectoryState;
import com.amazonaws.services.clouddirectory.model.transform.DirectoryMarshaller;
import java.io.Serializable;
import java.util.Date;

public class Directory
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String directoryArn;
    private String state;
    private Date creationDateTime;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Directory withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public Directory withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Directory withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(DirectoryState state) {
        this.state = state.toString();
    }

    public Directory withState(DirectoryState state) {
        this.setState(state);
        return this;
    }

    public void setCreationDateTime(Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public Directory withCreationDateTime(Date creationDateTime) {
        this.setCreationDateTime(creationDateTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getCreationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.getCreationDateTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Directory)) {
            return false;
        }
        Directory other = (Directory)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getCreationDateTime() == null ^ this.getCreationDateTime() == null) {
            return false;
        }
        return other.getCreationDateTime() == null || other.getCreationDateTime().equals(this.getCreationDateTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDateTime() == null ? 0 : this.getCreationDateTime().hashCode());
        return hashCode;
    }

    public Directory clone() {
        try {
            return (Directory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

