/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListDocumentsRequestMarshaller
implements Marshaller<Request<ListDocumentsRequest>, ListDocumentsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDocumentsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListDocumentsRequest> marshall(ListDocumentsRequest listDocumentsRequest) {
        if (listDocumentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDocumentsRequest> request = new DefaultRequest<ListDocumentsRequest>(listDocumentsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListDocuments");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList documentFilterListList = (SdkInternalList)listDocumentsRequest.getDocumentFilterList();
            if (!documentFilterListList.isEmpty() || !documentFilterListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DocumentFilterList");
                jsonGenerator.writeStartArray();
                for (DocumentFilter documentFilterListListValue : documentFilterListList) {
                    if (documentFilterListListValue == null) continue;
                    DocumentFilterJsonMarshaller.getInstance().marshall(documentFilterListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (listDocumentsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listDocumentsRequest.getMaxResults());
            }
            if (listDocumentsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listDocumentsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

