/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.VpcConfig;

public class VpcConfigJsonMarshaller {
    private static VpcConfigJsonMarshaller instance;

    public void marshall(VpcConfig vpcConfig, StructuredJsonGenerator jsonGenerator) {
        if (vpcConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList securityGroupIdsList;
            jsonGenerator.writeStartObject();
            SdkInternalList subnetIdsList = (SdkInternalList)vpcConfig.getSubnetIds();
            if (!subnetIdsList.isEmpty() || !subnetIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(securityGroupIdsList = (SdkInternalList)vpcConfig.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VpcConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VpcConfigJsonMarshaller();
        }
        return instance;
    }
}

