/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.UpdateCACertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class UpdateCACertificateRequestMarshaller
implements Marshaller<Request<UpdateCACertificateRequest>, UpdateCACertificateRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateCACertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateCACertificateRequest> marshall(UpdateCACertificateRequest updateCACertificateRequest) {
        if (updateCACertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateCACertificateRequest> request = new DefaultRequest<UpdateCACertificateRequest>(updateCACertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/cacertificate/{caCertificateId}";
        uriResourcePath = uriResourcePath.replace("{caCertificateId}", updateCACertificateRequest.getCertificateId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateCACertificateRequest.getCertificateId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (updateCACertificateRequest.getNewStatus() != null) {
            request.addParameter("newStatus", StringUtils.fromString(updateCACertificateRequest.getNewStatus()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

