/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.NodeGroup;
import com.amazonaws.services.elasticache.model.transform.EndpointStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.NodeGroupMemberStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class NodeGroupStaxUnmarshaller
implements Unmarshaller<NodeGroup, StaxUnmarshallerContext> {
    private static NodeGroupStaxUnmarshaller instance;

    @Override
    public NodeGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        NodeGroup nodeGroup = new NodeGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return nodeGroup;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NodeGroupId", targetDepth)) {
                    nodeGroup.setNodeGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    nodeGroup.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PrimaryEndpoint", targetDepth)) {
                    nodeGroup.setPrimaryEndpoint(EndpointStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("NodeGroupMembers/NodeGroupMember", targetDepth)) continue;
                nodeGroup.withNodeGroupMembers(NodeGroupMemberStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return nodeGroup;
    }

    public static NodeGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NodeGroupStaxUnmarshaller();
        }
        return instance;
    }
}

