/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteBasePathMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteBasePathMappingRequestMarshaller
implements Marshaller<Request<DeleteBasePathMappingRequest>, DeleteBasePathMappingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteBasePathMappingRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteBasePathMappingRequest> marshall(DeleteBasePathMappingRequest deleteBasePathMappingRequest) {
        if (deleteBasePathMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBasePathMappingRequest> request = new DefaultRequest<DeleteBasePathMappingRequest>(deleteBasePathMappingRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings/{base_path}";
        uriResourcePath = uriResourcePath.replace("{domain_name}", deleteBasePathMappingRequest.getDomainName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteBasePathMappingRequest.getDomainName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{base_path}", deleteBasePathMappingRequest.getBasePath() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteBasePathMappingRequest.getBasePath()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

