/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.importexport.AmazonImportExportAsync;
import com.amazonaws.services.importexport.AmazonImportExportClient;
import com.amazonaws.services.importexport.model.CancelJobRequest;
import com.amazonaws.services.importexport.model.CancelJobResult;
import com.amazonaws.services.importexport.model.CreateJobRequest;
import com.amazonaws.services.importexport.model.CreateJobResult;
import com.amazonaws.services.importexport.model.GetShippingLabelRequest;
import com.amazonaws.services.importexport.model.GetShippingLabelResult;
import com.amazonaws.services.importexport.model.GetStatusRequest;
import com.amazonaws.services.importexport.model.GetStatusResult;
import com.amazonaws.services.importexport.model.ListJobsRequest;
import com.amazonaws.services.importexport.model.ListJobsResult;
import com.amazonaws.services.importexport.model.UpdateJobRequest;
import com.amazonaws.services.importexport.model.UpdateJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonImportExportAsyncClient
extends AmazonImportExportClient
implements AmazonImportExportAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonImportExportAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonImportExportAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AmazonImportExportAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonImportExportAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(final CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result;
                try {
                    result = AmazonImportExportAsyncClient.this.cancelJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(final CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result;
                try {
                    result = AmazonImportExportAsyncClient.this.createJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetShippingLabelResult> getShippingLabelAsync(GetShippingLabelRequest request) {
        return this.getShippingLabelAsync(request, null);
    }

    @Override
    public Future<GetShippingLabelResult> getShippingLabelAsync(final GetShippingLabelRequest request, final AsyncHandler<GetShippingLabelRequest, GetShippingLabelResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetShippingLabelResult>(){

            @Override
            public GetShippingLabelResult call() throws Exception {
                GetShippingLabelResult result;
                try {
                    result = AmazonImportExportAsyncClient.this.getShippingLabel(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStatusResult> getStatusAsync(GetStatusRequest request) {
        return this.getStatusAsync(request, null);
    }

    @Override
    public Future<GetStatusResult> getStatusAsync(final GetStatusRequest request, final AsyncHandler<GetStatusRequest, GetStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetStatusResult>(){

            @Override
            public GetStatusResult call() throws Exception {
                GetStatusResult result;
                try {
                    result = AmazonImportExportAsyncClient.this.getStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result;
                try {
                    result = AmazonImportExportAsyncClient.this.listJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync() {
        return this.listJobsAsync(new ListJobsRequest());
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        return this.listJobsAsync(new ListJobsRequest(), asyncHandler);
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(UpdateJobRequest request) {
        return this.updateJobAsync(request, null);
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(final UpdateJobRequest request, final AsyncHandler<UpdateJobRequest, UpdateJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateJobResult>(){

            @Override
            public UpdateJobResult call() throws Exception {
                UpdateJobResult result;
                try {
                    result = AmazonImportExportAsyncClient.this.updateJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }
}

