/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeServicesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private ListWithAutoConstructFlag<String> services;

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public DescribeServicesRequest withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public List<String> getServices() {
        if (this.services == null) {
            this.services = new ListWithAutoConstructFlag();
            this.services.setAutoConstruct(true);
        }
        return this.services;
    }

    public void setServices(Collection<String> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        ListWithAutoConstructFlag servicesCopy = new ListWithAutoConstructFlag(services.size());
        servicesCopy.addAll(services);
        this.services = servicesCopy;
    }

    public DescribeServicesRequest withServices(String ... services) {
        if (this.getServices() == null) {
            this.setServices(new ArrayList<String>(services.length));
        }
        for (String value : services) {
            this.getServices().add(value);
        }
        return this;
    }

    public DescribeServicesRequest withServices(Collection<String> services) {
        if (services == null) {
            this.services = null;
        } else {
            ListWithAutoConstructFlag servicesCopy = new ListWithAutoConstructFlag(services.size());
            servicesCopy.addAll(services);
            this.services = servicesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: " + this.getCluster() + ",");
        }
        if (this.getServices() != null) {
            sb.append("Services: " + this.getServices());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        return other.getServices() == null || other.getServices().equals(this.getServices());
    }

    @Override
    public DescribeServicesRequest clone() {
        return (DescribeServicesRequest)super.clone();
    }
}

