/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.ShrinkPolicy;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceResizePolicyJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ShrinkPolicyJsonMarshaller {
    private static ShrinkPolicyJsonMarshaller instance;

    public void marshall(ShrinkPolicy shrinkPolicy, StructuredJsonGenerator jsonGenerator) {
        if (shrinkPolicy == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (shrinkPolicy.getDecommissionTimeout() != null) {
                jsonGenerator.writeFieldName("DecommissionTimeout").writeValue(shrinkPolicy.getDecommissionTimeout());
            }
            if (shrinkPolicy.getInstanceResizePolicy() != null) {
                jsonGenerator.writeFieldName("InstanceResizePolicy");
                InstanceResizePolicyJsonMarshaller.getInstance().marshall(shrinkPolicy.getInstanceResizePolicy(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ShrinkPolicyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ShrinkPolicyJsonMarshaller();
        }
        return instance;
    }
}

