/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetModelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetModelRequestMarshaller
implements Marshaller<Request<GetModelRequest>, GetModelRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetModelRequest> marshall(GetModelRequest getModelRequest) {
        if (getModelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetModelRequest> request = new DefaultRequest<GetModelRequest>(getModelRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/models/{model_name}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getModelRequest.getRestApiId() != null ? StringUtils.fromString(getModelRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{model_name}", getModelRequest.getModelName() != null ? StringUtils.fromString(getModelRequest.getModelName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (getModelRequest.getFlatten() != null) {
            request.addParameter("flatten", StringUtils.fromBoolean(getModelRequest.getFlatten()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

