/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;

public class UpdateAliasRequestMarshaller
implements Marshaller<Request<UpdateAliasRequest>, UpdateAliasRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<UpdateAliasRequest> marshall(UpdateAliasRequest updateAliasRequest) {
        if (updateAliasRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateAliasRequest> request = new DefaultRequest<UpdateAliasRequest>(updateAliasRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/aliases/{Name}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", updateAliasRequest.getFunctionName() != null ? StringUtils.fromString(updateAliasRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{Name}", updateAliasRequest.getName() != null ? StringUtils.fromString(updateAliasRequest.getName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateAliasRequest.getFunctionVersion() != null) {
                jsonGenerator.writeFieldName("FunctionVersion").writeValue(updateAliasRequest.getFunctionVersion());
            }
            if (updateAliasRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateAliasRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

