/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsRequest;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class AddAttributesToFindingsRequestMarshaller
implements Marshaller<Request<AddAttributesToFindingsRequest>, AddAttributesToFindingsRequest> {
    @Override
    public Request<AddAttributesToFindingsRequest> marshall(AddAttributesToFindingsRequest addAttributesToFindingsRequest) {
        if (addAttributesToFindingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddAttributesToFindingsRequest> request = new DefaultRequest<AddAttributesToFindingsRequest>(addAttributesToFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.AddAttributesToFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Attribute> attributesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            List<String> findingArnsList = addAttributesToFindingsRequest.getFindingArns();
            if (findingArnsList != null) {
                jsonGenerator.writeFieldName("findingArns");
                jsonGenerator.writeStartArray();
                for (String findingArnsListValue : findingArnsList) {
                    if (findingArnsListValue == null) continue;
                    jsonGenerator.writeValue(findingArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((attributesList = addAttributesToFindingsRequest.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

