/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeImportImageTasksRequestMarshaller
implements Marshaller<Request<DescribeImportImageTasksRequest>, DescribeImportImageTasksRequest> {
    @Override
    public Request<DescribeImportImageTasksRequest> marshall(DescribeImportImageTasksRequest describeImportImageTasksRequest) {
        SdkInternalList filtersList;
        if (describeImportImageTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeImportImageTasksRequest> request = new DefaultRequest<DescribeImportImageTasksRequest>(describeImportImageTasksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeImportImageTasks");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList importTaskIdsList = (SdkInternalList)describeImportImageTasksRequest.getImportTaskIds();
        if (!importTaskIdsList.isEmpty() || !importTaskIdsList.isAutoConstruct()) {
            int importTaskIdsListIndex = 1;
            for (String importTaskIdsListValue : importTaskIdsList) {
                if (importTaskIdsListValue != null) {
                    request.addParameter("ImportTaskId." + importTaskIdsListIndex, StringUtils.fromString(importTaskIdsListValue));
                }
                ++importTaskIdsListIndex;
            }
        }
        if (describeImportImageTasksRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeImportImageTasksRequest.getNextToken()));
        }
        if (describeImportImageTasksRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeImportImageTasksRequest.getMaxResults()));
        }
        if (!(filtersList = (SdkInternalList)describeImportImageTasksRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

