/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.ListBranchesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListBranchesRequestMarshaller
implements Marshaller<Request<ListBranchesRequest>, ListBranchesRequest> {
    @Override
    public Request<ListBranchesRequest> marshall(ListBranchesRequest listBranchesRequest) {
        if (listBranchesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListBranchesRequest> request = new DefaultRequest<ListBranchesRequest>(listBranchesRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.ListBranches");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listBranchesRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(listBranchesRequest.getRepositoryName());
            }
            if (listBranchesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listBranchesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

