/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class RemoveTargetsRequestMarshaller
implements Marshaller<Request<RemoveTargetsRequest>, RemoveTargetsRequest> {
    @Override
    public Request<RemoveTargetsRequest> marshall(RemoveTargetsRequest removeTargetsRequest) {
        if (removeTargetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RemoveTargetsRequest> request = new DefaultRequest<RemoveTargetsRequest>(removeTargetsRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.RemoveTargets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> idsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (removeTargetsRequest.getRule() != null) {
                jsonGenerator.writeFieldName("Rule").writeValue(removeTargetsRequest.getRule());
            }
            if ((idsList = removeTargetsRequest.getIds()) != null) {
                jsonGenerator.writeFieldName("Ids");
                jsonGenerator.writeStartArray();
                for (String idsListValue : idsList) {
                    if (idsListValue == null) continue;
                    jsonGenerator.writeValue(idsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

