/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.DeleteTagsForDomainRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DeleteTagsForDomainRequestMarshaller
implements Marshaller<Request<DeleteTagsForDomainRequest>, DeleteTagsForDomainRequest> {
    @Override
    public Request<DeleteTagsForDomainRequest> marshall(DeleteTagsForDomainRequest deleteTagsForDomainRequest) {
        if (deleteTagsForDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteTagsForDomainRequest> request = new DefaultRequest<DeleteTagsForDomainRequest>(deleteTagsForDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.DeleteTagsForDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsToDeleteList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (deleteTagsForDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(deleteTagsForDomainRequest.getDomainName());
            }
            if (!(tagsToDeleteList = (SdkInternalList)deleteTagsForDomainRequest.getTagsToDelete()).isEmpty() || !tagsToDeleteList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TagsToDelete");
                jsonGenerator.writeStartArray();
                for (String tagsToDeleteListValue : tagsToDeleteList) {
                    if (tagsToDeleteListValue == null) continue;
                    jsonGenerator.writeValue(tagsToDeleteListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

