/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.services.route53.model.HealthCheckConfig;
import com.amazonaws.services.route53.model.transform.AlarmIdentifierStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class HealthCheckConfigStaxUnmarshaller
implements Unmarshaller<HealthCheckConfig, StaxUnmarshallerContext> {
    private static HealthCheckConfigStaxUnmarshaller instance;

    @Override
    public HealthCheckConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        HealthCheckConfig healthCheckConfig = new HealthCheckConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return healthCheckConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("IPAddress", targetDepth)) {
                    healthCheckConfig.setIPAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    healthCheckConfig.setPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Type", targetDepth)) {
                    healthCheckConfig.setType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourcePath", targetDepth)) {
                    healthCheckConfig.setResourcePath(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FullyQualifiedDomainName", targetDepth)) {
                    healthCheckConfig.setFullyQualifiedDomainName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchString", targetDepth)) {
                    healthCheckConfig.setSearchString(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequestInterval", targetDepth)) {
                    healthCheckConfig.setRequestInterval(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FailureThreshold", targetDepth)) {
                    healthCheckConfig.setFailureThreshold(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MeasureLatency", targetDepth)) {
                    healthCheckConfig.setMeasureLatency(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Inverted", targetDepth)) {
                    healthCheckConfig.setInverted(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthThreshold", targetDepth)) {
                    healthCheckConfig.setHealthThreshold(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ChildHealthChecks/ChildHealthCheck", targetDepth)) {
                    healthCheckConfig.withChildHealthChecks(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EnableSNI", targetDepth)) {
                    healthCheckConfig.setEnableSNI(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Regions/Region", targetDepth)) {
                    healthCheckConfig.withRegions(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AlarmIdentifier", targetDepth)) {
                    healthCheckConfig.setAlarmIdentifier(AlarmIdentifierStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("InsufficientDataHealthStatus", targetDepth)) continue;
                healthCheckConfig.setInsufficientDataHealthStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return healthCheckConfig;
    }

    public static HealthCheckConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HealthCheckConfigStaxUnmarshaller();
        }
        return instance;
    }
}

