/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListTagsForStreamRequestMarshaller
implements Marshaller<Request<ListTagsForStreamRequest>, ListTagsForStreamRequest> {
    @Override
    public Request<ListTagsForStreamRequest> marshall(ListTagsForStreamRequest listTagsForStreamRequest) {
        if (listTagsForStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTagsForStreamRequest> request = new DefaultRequest<ListTagsForStreamRequest>(listTagsForStreamRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.ListTagsForStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listTagsForStreamRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(listTagsForStreamRequest.getStreamName());
            }
            if (listTagsForStreamRequest.getExclusiveStartTagKey() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartTagKey").writeValue(listTagsForStreamRequest.getExclusiveStartTagKey());
            }
            if (listTagsForStreamRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listTagsForStreamRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

