/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.Finding;
import com.amazonaws.services.inspector.model.transform.AssetAttributesJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.AttributeJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.InspectorServiceAttributesJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;

public class FindingJsonUnmarshaller
implements Unmarshaller<Finding, JsonUnmarshallerContext> {
    private static FindingJsonUnmarshaller instance;

    @Override
    public Finding unmarshall(JsonUnmarshallerContext context) throws Exception {
        Finding finding = new Finding();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    finding.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("schemaVersion", targetDepth)) {
                    context.nextToken();
                    finding.setSchemaVersion(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("service", targetDepth)) {
                    context.nextToken();
                    finding.setService(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("serviceAttributes", targetDepth)) {
                    context.nextToken();
                    finding.setServiceAttributes(InspectorServiceAttributesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("assetType", targetDepth)) {
                    context.nextToken();
                    finding.setAssetType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("assetAttributes", targetDepth)) {
                    context.nextToken();
                    finding.setAssetAttributes(AssetAttributesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    finding.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("title", targetDepth)) {
                    context.nextToken();
                    finding.setTitle(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    finding.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("recommendation", targetDepth)) {
                    context.nextToken();
                    finding.setRecommendation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("severity", targetDepth)) {
                    context.nextToken();
                    finding.setSeverity(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("numericSeverity", targetDepth)) {
                    context.nextToken();
                    finding.setNumericSeverity(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("confidence", targetDepth)) {
                    context.nextToken();
                    finding.setConfidence(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("indicatorOfCompromise", targetDepth)) {
                    context.nextToken();
                    finding.setIndicatorOfCompromise(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("attributes", targetDepth)) {
                    context.nextToken();
                    finding.setAttributes(new ListUnmarshaller<Attribute>(AttributeJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("userAttributes", targetDepth)) {
                    context.nextToken();
                    finding.setUserAttributes(new ListUnmarshaller<Attribute>(AttributeJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    finding.setCreatedAt(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("updatedAt", targetDepth)) {
                    context.nextToken();
                    finding.setUpdatedAt(context.getUnmarshaller(Date.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return finding;
    }

    public static FindingJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FindingJsonUnmarshaller();
        }
        return instance;
    }
}

