/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class GamePropertyJsonMarshaller {
    private static GamePropertyJsonMarshaller instance;

    public void marshall(GameProperty gameProperty, StructuredJsonGenerator jsonGenerator) {
        if (gameProperty == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (gameProperty.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(gameProperty.getKey());
            }
            if (gameProperty.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(gameProperty.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GamePropertyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GamePropertyJsonMarshaller();
        }
        return instance;
    }
}

