/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.gamelift.model.Alias;
import com.amazonaws.services.gamelift.model.transform.RoutingStrategyJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class AliasJsonMarshaller {
    private static AliasJsonMarshaller instance;

    public void marshall(Alias alias, StructuredJsonGenerator jsonGenerator) {
        if (alias == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (alias.getAliasId() != null) {
                jsonGenerator.writeFieldName("AliasId").writeValue(alias.getAliasId());
            }
            if (alias.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(alias.getName());
            }
            if (alias.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(alias.getDescription());
            }
            if (alias.getRoutingStrategy() != null) {
                jsonGenerator.writeFieldName("RoutingStrategy");
                RoutingStrategyJsonMarshaller.getInstance().marshall(alias.getRoutingStrategy(), jsonGenerator);
            }
            if (alias.getCreationTime() != null) {
                jsonGenerator.writeFieldName("CreationTime").writeValue(alias.getCreationTime());
            }
            if (alias.getLastUpdatedTime() != null) {
                jsonGenerator.writeFieldName("LastUpdatedTime").writeValue(alias.getLastUpdatedTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AliasJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AliasJsonMarshaller();
        }
        return instance;
    }
}

