/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.Artwork;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ArtworkJsonMarshaller {
    private static ArtworkJsonMarshaller instance;

    public void marshall(Artwork artwork, StructuredJsonGenerator jsonGenerator) {
        if (artwork == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (artwork.getInputKey() != null) {
                jsonGenerator.writeFieldName("InputKey").writeValue(artwork.getInputKey());
            }
            if (artwork.getMaxWidth() != null) {
                jsonGenerator.writeFieldName("MaxWidth").writeValue(artwork.getMaxWidth());
            }
            if (artwork.getMaxHeight() != null) {
                jsonGenerator.writeFieldName("MaxHeight").writeValue(artwork.getMaxHeight());
            }
            if (artwork.getSizingPolicy() != null) {
                jsonGenerator.writeFieldName("SizingPolicy").writeValue(artwork.getSizingPolicy());
            }
            if (artwork.getPaddingPolicy() != null) {
                jsonGenerator.writeFieldName("PaddingPolicy").writeValue(artwork.getPaddingPolicy());
            }
            if (artwork.getAlbumArtFormat() != null) {
                jsonGenerator.writeFieldName("AlbumArtFormat").writeValue(artwork.getAlbumArtFormat());
            }
            if (artwork.getEncryption() != null) {
                jsonGenerator.writeFieldName("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(artwork.getEncryption(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ArtworkJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ArtworkJsonMarshaller();
        }
        return instance;
    }
}

