/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.CreateConnectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateConnectionRequestMarshaller
implements Marshaller<Request<CreateConnectionRequest>, CreateConnectionRequest> {
    @Override
    public Request<CreateConnectionRequest> marshall(CreateConnectionRequest createConnectionRequest) {
        if (createConnectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateConnectionRequest> request = new DefaultRequest<CreateConnectionRequest>(createConnectionRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.CreateConnection");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createConnectionRequest.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(createConnectionRequest.getLocation());
            }
            if (createConnectionRequest.getBandwidth() != null) {
                jsonGenerator.writeFieldName("bandwidth").writeValue(createConnectionRequest.getBandwidth());
            }
            if (createConnectionRequest.getConnectionName() != null) {
                jsonGenerator.writeFieldName("connectionName").writeValue(createConnectionRequest.getConnectionName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

