/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.databasemigrationservice.model.ReplicationSubnetGroup;
import com.amazonaws.services.databasemigrationservice.model.Subnet;
import com.amazonaws.services.databasemigrationservice.model.transform.SubnetJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class ReplicationSubnetGroupJsonMarshaller {
    private static ReplicationSubnetGroupJsonMarshaller instance;

    public void marshall(ReplicationSubnetGroup replicationSubnetGroup, StructuredJsonGenerator jsonGenerator) {
        if (replicationSubnetGroup == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Subnet> subnetsList;
            jsonGenerator.writeStartObject();
            if (replicationSubnetGroup.getReplicationSubnetGroupIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationSubnetGroupIdentifier").writeValue(replicationSubnetGroup.getReplicationSubnetGroupIdentifier());
            }
            if (replicationSubnetGroup.getReplicationSubnetGroupDescription() != null) {
                jsonGenerator.writeFieldName("ReplicationSubnetGroupDescription").writeValue(replicationSubnetGroup.getReplicationSubnetGroupDescription());
            }
            if (replicationSubnetGroup.getVpcId() != null) {
                jsonGenerator.writeFieldName("VpcId").writeValue(replicationSubnetGroup.getVpcId());
            }
            if (replicationSubnetGroup.getSubnetGroupStatus() != null) {
                jsonGenerator.writeFieldName("SubnetGroupStatus").writeValue(replicationSubnetGroup.getSubnetGroupStatus());
            }
            if ((subnetsList = replicationSubnetGroup.getSubnets()) != null) {
                jsonGenerator.writeFieldName("Subnets");
                jsonGenerator.writeStartArray();
                for (Subnet subnetsListValue : subnetsList) {
                    if (subnetsListValue == null) continue;
                    SubnetJsonMarshaller.getInstance().marshall(subnetsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReplicationSubnetGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReplicationSubnetGroupJsonMarshaller();
        }
        return instance;
    }
}

