/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.RepositoryTrigger;
import com.amazonaws.services.codecommit.model.transform.RepositoryTriggerJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class PutRepositoryTriggersRequestMarshaller
implements Marshaller<Request<PutRepositoryTriggersRequest>, PutRepositoryTriggersRequest> {
    @Override
    public Request<PutRepositoryTriggersRequest> marshall(PutRepositoryTriggersRequest putRepositoryTriggersRequest) {
        if (putRepositoryTriggersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutRepositoryTriggersRequest> request = new DefaultRequest<PutRepositoryTriggersRequest>(putRepositoryTriggersRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.PutRepositoryTriggers");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<RepositoryTrigger> triggersList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (putRepositoryTriggersRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(putRepositoryTriggersRequest.getRepositoryName());
            }
            if ((triggersList = putRepositoryTriggersRequest.getTriggers()) != null) {
                jsonGenerator.writeFieldName("triggers");
                jsonGenerator.writeStartArray();
                for (RepositoryTrigger triggersListValue : triggersList) {
                    if (triggersListValue == null) continue;
                    RepositoryTriggerJsonMarshaller.getInstance().marshall(triggersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

