/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatchevents.model.DeleteRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DeleteRuleRequestMarshaller
implements Marshaller<Request<DeleteRuleRequest>, DeleteRuleRequest> {
    @Override
    public Request<DeleteRuleRequest> marshall(DeleteRuleRequest deleteRuleRequest) {
        if (deleteRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteRuleRequest> request = new DefaultRequest<DeleteRuleRequest>(deleteRuleRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.DeleteRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (deleteRuleRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(deleteRuleRequest.getName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

