/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Model;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ModelJsonMarshaller {
    private static ModelJsonMarshaller instance;

    public void marshall(Model model, StructuredJsonGenerator jsonGenerator) {
        if (model == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (model.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(model.getId());
            }
            if (model.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(model.getName());
            }
            if (model.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(model.getDescription());
            }
            if (model.getSchema() != null) {
                jsonGenerator.writeFieldName("schema").writeValue(model.getSchema());
            }
            if (model.getContentType() != null) {
                jsonGenerator.writeFieldName("contentType").writeValue(model.getContentType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ModelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ModelJsonMarshaller();
        }
        return instance;
    }
}

