/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetMethodResponseRequestMarshaller
implements Marshaller<Request<GetMethodResponseRequest>, GetMethodResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetMethodResponseRequest> marshall(GetMethodResponseRequest getMethodResponseRequest) {
        if (getMethodResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetMethodResponseRequest> request = new DefaultRequest<GetMethodResponseRequest>(getMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getMethodResponseRequest.getRestApiId() != null ? StringUtils.fromString(getMethodResponseRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{resource_id}", getMethodResponseRequest.getResourceId() != null ? StringUtils.fromString(getMethodResponseRequest.getResourceId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{http_method}", getMethodResponseRequest.getHttpMethod() != null ? StringUtils.fromString(getMethodResponseRequest.getHttpMethod()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{status_code}", getMethodResponseRequest.getStatusCode() != null ? StringUtils.fromString(getMethodResponseRequest.getStatusCode()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

