/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateAuthorizerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateAuthorizerRequestMarshaller
implements Marshaller<Request<CreateAuthorizerRequest>, CreateAuthorizerRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateAuthorizerRequest> marshall(CreateAuthorizerRequest createAuthorizerRequest) {
        if (createAuthorizerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAuthorizerRequest> request = new DefaultRequest<CreateAuthorizerRequest>(createAuthorizerRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createAuthorizerRequest.getRestApiId() != null ? StringUtils.fromString(createAuthorizerRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createAuthorizerRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createAuthorizerRequest.getName());
            }
            if (createAuthorizerRequest.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(createAuthorizerRequest.getType());
            }
            if (createAuthorizerRequest.getAuthType() != null) {
                jsonGenerator.writeFieldName("authType").writeValue(createAuthorizerRequest.getAuthType());
            }
            if (createAuthorizerRequest.getAuthorizerUri() != null) {
                jsonGenerator.writeFieldName("authorizerUri").writeValue(createAuthorizerRequest.getAuthorizerUri());
            }
            if (createAuthorizerRequest.getAuthorizerCredentials() != null) {
                jsonGenerator.writeFieldName("authorizerCredentials").writeValue(createAuthorizerRequest.getAuthorizerCredentials());
            }
            if (createAuthorizerRequest.getIdentitySource() != null) {
                jsonGenerator.writeFieldName("identitySource").writeValue(createAuthorizerRequest.getIdentitySource());
            }
            if (createAuthorizerRequest.getIdentityValidationExpression() != null) {
                jsonGenerator.writeFieldName("identityValidationExpression").writeValue(createAuthorizerRequest.getIdentityValidationExpression());
            }
            if (createAuthorizerRequest.getAuthorizerResultTtlInSeconds() != null) {
                jsonGenerator.writeFieldName("authorizerResultTtlInSeconds").writeValue(createAuthorizerRequest.getAuthorizerResultTtlInSeconds());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

