/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.DescribeThingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeThingRequestMarshaller
implements Marshaller<Request<DescribeThingRequest>, DescribeThingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DescribeThingRequest> marshall(DescribeThingRequest describeThingRequest) {
        if (describeThingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeThingRequest> request = new DefaultRequest<DescribeThingRequest>(describeThingRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/things/{thingName}";
        uriResourcePath = uriResourcePath.replace("{thingName}", describeThingRequest.getThingName() != null ? StringUtils.fromString(describeThingRequest.getThingName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

