/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class AdminDeleteUserAttributesRequestMarshaller
implements Marshaller<Request<AdminDeleteUserAttributesRequest>, AdminDeleteUserAttributesRequest> {
    @Override
    public Request<AdminDeleteUserAttributesRequest> marshall(AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) {
        if (adminDeleteUserAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AdminDeleteUserAttributesRequest> request = new DefaultRequest<AdminDeleteUserAttributesRequest>(adminDeleteUserAttributesRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminDeleteUserAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> userAttributeNamesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (adminDeleteUserAttributesRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminDeleteUserAttributesRequest.getUserPoolId());
            }
            if (adminDeleteUserAttributesRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(adminDeleteUserAttributesRequest.getUsername());
            }
            if ((userAttributeNamesList = adminDeleteUserAttributesRequest.getUserAttributeNames()) != null) {
                jsonGenerator.writeFieldName("UserAttributeNames");
                jsonGenerator.writeStartArray();
                for (String userAttributeNamesListValue : userAttributeNamesList) {
                    if (userAttributeNamesListValue == null) continue;
                    jsonGenerator.writeValue(userAttributeNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

