/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.ImportRestApiRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.util.Map;

public class ImportRestApiRequestMarshaller
implements Marshaller<Request<ImportRestApiRequest>, ImportRestApiRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<ImportRestApiRequest> marshall(ImportRestApiRequest importRestApiRequest) {
        Map<String, String> parameters;
        if (importRestApiRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportRestApiRequest> request = new DefaultRequest<ImportRestApiRequest>(importRestApiRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis?mode=import";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (importRestApiRequest.getFailOnWarnings() != null) {
            request.addParameter("failonwarnings", StringUtils.fromBoolean(importRestApiRequest.getFailOnWarnings()));
        }
        if ((parameters = importRestApiRequest.getParameters()) != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                request.addParameter(StringUtils.fromString(entry.getKey()), StringUtils.fromString(entry.getValue()));
            }
        }
        request.setContent(BinaryUtils.toStream(importRestApiRequest.getBody()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

