/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetResourcesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetResourcesRequestMarshaller
implements Marshaller<Request<GetResourcesRequest>, GetResourcesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetResourcesRequest> marshall(GetResourcesRequest getResourcesRequest) {
        if (getResourcesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetResourcesRequest> request = new DefaultRequest<GetResourcesRequest>(getResourcesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getResourcesRequest.getRestApiId() != null ? StringUtils.fromString(getResourcesRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (getResourcesRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getResourcesRequest.getPosition()));
        }
        if (getResourcesRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getResourcesRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

