/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.machinelearning.model.RedshiftDataSpec;
import com.amazonaws.services.machinelearning.model.transform.RedshiftDatabaseCredentialsJsonMarshaller;
import com.amazonaws.services.machinelearning.model.transform.RedshiftDatabaseJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class RedshiftDataSpecJsonMarshaller {
    private static RedshiftDataSpecJsonMarshaller instance;

    public void marshall(RedshiftDataSpec redshiftDataSpec, StructuredJsonGenerator jsonGenerator) {
        if (redshiftDataSpec == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (redshiftDataSpec.getDatabaseInformation() != null) {
                jsonGenerator.writeFieldName("DatabaseInformation");
                RedshiftDatabaseJsonMarshaller.getInstance().marshall(redshiftDataSpec.getDatabaseInformation(), jsonGenerator);
            }
            if (redshiftDataSpec.getSelectSqlQuery() != null) {
                jsonGenerator.writeFieldName("SelectSqlQuery").writeValue(redshiftDataSpec.getSelectSqlQuery());
            }
            if (redshiftDataSpec.getDatabaseCredentials() != null) {
                jsonGenerator.writeFieldName("DatabaseCredentials");
                RedshiftDatabaseCredentialsJsonMarshaller.getInstance().marshall(redshiftDataSpec.getDatabaseCredentials(), jsonGenerator);
            }
            if (redshiftDataSpec.getS3StagingLocation() != null) {
                jsonGenerator.writeFieldName("S3StagingLocation").writeValue(redshiftDataSpec.getS3StagingLocation());
            }
            if (redshiftDataSpec.getDataRearrangement() != null) {
                jsonGenerator.writeFieldName("DataRearrangement").writeValue(redshiftDataSpec.getDataRearrangement());
            }
            if (redshiftDataSpec.getDataSchema() != null) {
                jsonGenerator.writeFieldName("DataSchema").writeValue(redshiftDataSpec.getDataSchema());
            }
            if (redshiftDataSpec.getDataSchemaUri() != null) {
                jsonGenerator.writeFieldName("DataSchemaUri").writeValue(redshiftDataSpec.getDataSchemaUri());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RedshiftDataSpecJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RedshiftDataSpecJsonMarshaller();
        }
        return instance;
    }
}

