/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.HashKeyRange;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class HashKeyRangeJsonUnmarshaller
implements Unmarshaller<HashKeyRange, JsonUnmarshallerContext> {
    private static HashKeyRangeJsonUnmarshaller instance;

    @Override
    public HashKeyRange unmarshall(JsonUnmarshallerContext context) throws Exception {
        HashKeyRange hashKeyRange = new HashKeyRange();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StartingHashKey", targetDepth)) {
                    context.nextToken();
                    hashKeyRange.setStartingHashKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EndingHashKey", targetDepth)) {
                    context.nextToken();
                    hashKeyRange.setEndingHashKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return hashKeyRange;
    }

    public static HashKeyRangeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HashKeyRangeJsonUnmarshaller();
        }
        return instance;
    }
}

