/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.FindingFilter;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.TimestampRangeJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class FindingFilterJsonMarshaller {
    private static FindingFilterJsonMarshaller instance;

    public void marshall(FindingFilter findingFilter, StructuredJsonGenerator jsonGenerator) {
        if (findingFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesList;
            List<Attribute> attributesList;
            List<String> rulesPackageArnsList;
            List<String> severitiesList;
            List<String> ruleNamesList;
            List<String> autoScalingGroupsList;
            jsonGenerator.writeStartObject();
            List<String> agentIdsList = findingFilter.getAgentIds();
            if (agentIdsList != null) {
                jsonGenerator.writeFieldName("agentIds");
                jsonGenerator.writeStartArray();
                for (String agentIdsListValue : agentIdsList) {
                    if (agentIdsListValue == null) continue;
                    jsonGenerator.writeValue(agentIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((autoScalingGroupsList = findingFilter.getAutoScalingGroups()) != null) {
                jsonGenerator.writeFieldName("autoScalingGroups");
                jsonGenerator.writeStartArray();
                for (String autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    jsonGenerator.writeValue(autoScalingGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((ruleNamesList = findingFilter.getRuleNames()) != null) {
                jsonGenerator.writeFieldName("ruleNames");
                jsonGenerator.writeStartArray();
                for (String ruleNamesListValue : ruleNamesList) {
                    if (ruleNamesListValue == null) continue;
                    jsonGenerator.writeValue(ruleNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((severitiesList = findingFilter.getSeverities()) != null) {
                jsonGenerator.writeFieldName("severities");
                jsonGenerator.writeStartArray();
                for (String severitiesListValue : severitiesList) {
                    if (severitiesListValue == null) continue;
                    jsonGenerator.writeValue(severitiesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((rulesPackageArnsList = findingFilter.getRulesPackageArns()) != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackageArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((attributesList = findingFilter.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesList = findingFilter.getUserAttributes()) != null) {
                jsonGenerator.writeFieldName("userAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (findingFilter.getCreationTimeRange() != null) {
                jsonGenerator.writeFieldName("creationTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(findingFilter.getCreationTimeRange(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FindingFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FindingFilterJsonMarshaller();
        }
        return instance;
    }
}

