/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UploadMultipartPartRequestMarshaller
implements Marshaller<Request<UploadMultipartPartRequest>, UploadMultipartPartRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<UploadMultipartPartRequest> marshall(UploadMultipartPartRequest uploadMultipartPartRequest) {
        String value;
        String name;
        if (uploadMultipartPartRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadMultipartPartRequest> request = new DefaultRequest<UploadMultipartPartRequest>(uploadMultipartPartRequest, "AmazonGlacier");
        String target = "Glacier.UploadMultipartPart";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.PUT);
        if (uploadMultipartPartRequest.getChecksum() != null) {
            request.addHeader("x-amz-sha256-tree-hash", StringUtils.fromString(uploadMultipartPartRequest.getChecksum()));
        }
        if (uploadMultipartPartRequest.getRange() != null) {
            request.addHeader("Content-Range", StringUtils.fromString(uploadMultipartPartRequest.getRange()));
        }
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string = value = uploadMultipartPartRequest.getAccountId() == null ? null : StringUtils.fromString(uploadMultipartPartRequest.getAccountId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", uploadMultipartPartRequest.getAccountId() == null ? "" : StringUtils.fromString(uploadMultipartPartRequest.getAccountId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("vaultName")) {
            name = DYNAMIC_QUERY_PARAMS.get("vaultName");
            String string = value = uploadMultipartPartRequest.getVaultName() == null ? null : StringUtils.fromString(uploadMultipartPartRequest.getVaultName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{vaultName}", uploadMultipartPartRequest.getVaultName() == null ? "" : StringUtils.fromString(uploadMultipartPartRequest.getVaultName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("uploadId")) {
            name = DYNAMIC_QUERY_PARAMS.get("uploadId");
            String string = value = uploadMultipartPartRequest.getUploadId() == null ? null : StringUtils.fromString(uploadMultipartPartRequest.getUploadId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{uploadId}", uploadMultipartPartRequest.getUploadId() == null ? "" : StringUtils.fromString(uploadMultipartPartRequest.getUploadId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(uploadMultipartPartRequest.getBody());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }

    static {
        String path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

