/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.PendingModifiedValues;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PendingModifiedValuesStaxUnmarshaller
implements Unmarshaller<PendingModifiedValues, StaxUnmarshallerContext> {
    private static PendingModifiedValuesStaxUnmarshaller instance;

    @Override
    public PendingModifiedValues unmarshall(StaxUnmarshallerContext context) throws Exception {
        PendingModifiedValues pendingModifiedValues = new PendingModifiedValues();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return pendingModifiedValues;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NumCacheNodes", targetDepth)) {
                    pendingModifiedValues.setNumCacheNodes(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeIdsToRemove/CacheNodeId", targetDepth)) {
                    pendingModifiedValues.getCacheNodeIdsToRemove().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    pendingModifiedValues.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CacheNodeType", targetDepth)) continue;
                pendingModifiedValues.setCacheNodeType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return pendingModifiedValues;
    }

    public static PendingModifiedValuesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PendingModifiedValuesStaxUnmarshaller();
        }
        return instance;
    }
}

