/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.transform.PrefixListIdStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.UserIdGroupPairStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class IpPermissionStaxUnmarshaller
implements Unmarshaller<IpPermission, StaxUnmarshallerContext> {
    private static IpPermissionStaxUnmarshaller instance;

    @Override
    public IpPermission unmarshall(StaxUnmarshallerContext context) throws Exception {
        IpPermission ipPermission = new IpPermission();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return ipPermission;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ipProtocol", targetDepth)) {
                    ipPermission.setIpProtocol(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("fromPort", targetDepth)) {
                    ipPermission.setFromPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("toPort", targetDepth)) {
                    ipPermission.setToPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groups/item", targetDepth)) {
                    ipPermission.withUserIdGroupPairs(UserIdGroupPairStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipRanges/item/cidrIp", targetDepth)) {
                    ipPermission.withIpRanges(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("prefixListIds/item", targetDepth)) continue;
                ipPermission.withPrefixListIds(PrefixListIdStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return ipPermission;
    }

    public static IpPermissionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IpPermissionStaxUnmarshaller();
        }
        return instance;
    }
}

