/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.RevisionInfo;
import com.amazonaws.services.codedeploy.model.transform.GenericRevisionInfoJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class RevisionInfoJsonMarshaller {
    private static RevisionInfoJsonMarshaller instance;

    public void marshall(RevisionInfo revisionInfo, StructuredJsonGenerator jsonGenerator) {
        if (revisionInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (revisionInfo.getRevisionLocation() != null) {
                jsonGenerator.writeFieldName("revisionLocation");
                RevisionLocationJsonMarshaller.getInstance().marshall(revisionInfo.getRevisionLocation(), jsonGenerator);
            }
            if (revisionInfo.getGenericRevisionInfo() != null) {
                jsonGenerator.writeFieldName("genericRevisionInfo");
                GenericRevisionInfoJsonMarshaller.getInstance().marshall(revisionInfo.getGenericRevisionInfo(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RevisionInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RevisionInfoJsonMarshaller();
        }
        return instance;
    }
}

