/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudtrail.model.PublicKey;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class PublicKeyJsonMarshaller {
    private static PublicKeyJsonMarshaller instance;

    public void marshall(PublicKey publicKey, StructuredJsonGenerator jsonGenerator) {
        if (publicKey == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (publicKey.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(publicKey.getValue());
            }
            if (publicKey.getValidityStartTime() != null) {
                jsonGenerator.writeFieldName("ValidityStartTime").writeValue(publicKey.getValidityStartTime());
            }
            if (publicKey.getValidityEndTime() != null) {
                jsonGenerator.writeFieldName("ValidityEndTime").writeValue(publicKey.getValidityEndTime());
            }
            if (publicKey.getFingerprint() != null) {
                jsonGenerator.writeFieldName("Fingerprint").writeValue(publicKey.getFingerprint());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PublicKeyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PublicKeyJsonMarshaller();
        }
        return instance;
    }
}

