/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AddShapes;
import com.amazonaws.codegen.internal.NameUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.service.Input;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.util.HashMap;
import java.util.Map;

final class AddInputShapes
extends AddShapes {
    AddInputShapes(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        super(serviceModel, customizationConfig);
    }

    public final Map<String, ShapeModel> constructInputShapes() {
        HashMap<String, ShapeModel> javaShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : this.getServiceModel().getOperations().entrySet()) {
            String operationName = entry.getKey();
            Operation operation = entry.getValue();
            Input input = operation.getInput();
            if (input == null) continue;
            String javaRequestShapeName = NameUtils.getRequestClassName(input.getShape(), operationName);
            ShapeModel inputShape = this.generateInputShapeModel(operation, javaRequestShapeName);
            if (inputShape.getDocumentation() == null) {
                inputShape.setDocumentation(input.getDocumentation());
            }
            javaShapes.put(javaRequestShapeName, inputShape);
        }
        return javaShapes;
    }

    private ShapeModel generateInputShapeModel(Operation operation, String javaInputShapeNameOverride) {
        Input input = operation.getInput();
        String inputShapeName = input.getShape();
        ShapeModel shapeModel = this.generateShapeModel(javaInputShapeNameOverride, inputShapeName);
        shapeModel.setType(ShapeType.Request.getValue());
        shapeModel.setMarshaller(Utils.createInputShapeMarshaller(this.getServiceModel().getMetadata(), operation));
        return shapeModel;
    }
}

