/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.CreateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.WorkspaceRequest;
import com.amazonaws.services.workspaces.model.transform.WorkspaceRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateWorkspacesRequestMarshaller
implements Marshaller<Request<CreateWorkspacesRequest>, CreateWorkspacesRequest> {
    @Override
    public Request<CreateWorkspacesRequest> marshall(CreateWorkspacesRequest createWorkspacesRequest) {
        if (createWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateWorkspacesRequest> request = new DefaultRequest<CreateWorkspacesRequest>(createWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.CreateWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList workspacesList = (SdkInternalList)createWorkspacesRequest.getWorkspaces();
            if (!workspacesList.isEmpty() || !workspacesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Workspaces");
                jsonGenerator.writeStartArray();
                for (WorkspaceRequest workspacesListValue : workspacesList) {
                    if (workspacesListValue == null) continue;
                    WorkspaceRequestJsonMarshaller.getInstance().marshall(workspacesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

