/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeInstanceInformationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.InstanceInformationFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InstanceInformationFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DescribeInstanceInformationRequestMarshaller
implements Marshaller<Request<DescribeInstanceInformationRequest>, DescribeInstanceInformationRequest> {
    @Override
    public Request<DescribeInstanceInformationRequest> marshall(DescribeInstanceInformationRequest describeInstanceInformationRequest) {
        if (describeInstanceInformationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstanceInformationRequest> request = new DefaultRequest<DescribeInstanceInformationRequest>(describeInstanceInformationRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DescribeInstanceInformation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList instanceInformationFilterListList = (SdkInternalList)describeInstanceInformationRequest.getInstanceInformationFilterList();
            if (!instanceInformationFilterListList.isEmpty() || !instanceInformationFilterListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceInformationFilterList");
                jsonGenerator.writeStartArray();
                for (InstanceInformationFilter instanceInformationFilterListListValue : instanceInformationFilterListList) {
                    if (instanceInformationFilterListListValue == null) continue;
                    InstanceInformationFilterJsonMarshaller.getInstance().marshall(instanceInformationFilterListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeInstanceInformationRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeInstanceInformationRequest.getMaxResults());
            }
            if (describeInstanceInformationRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeInstanceInformationRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

