/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.Nameserver;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class NameserverJsonMarshaller {
    private static NameserverJsonMarshaller instance;

    public void marshall(Nameserver nameserver, StructuredJsonGenerator jsonGenerator) {
        if (nameserver == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList glueIpsList;
            jsonGenerator.writeStartObject();
            if (nameserver.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(nameserver.getName());
            }
            if (!(glueIpsList = (SdkInternalList)nameserver.getGlueIps()).isEmpty() || !glueIpsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("GlueIps");
                jsonGenerator.writeStartArray();
                for (String glueIpsListValue : glueIpsList) {
                    if (glueIpsListValue == null) continue;
                    jsonGenerator.writeValue(glueIpsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NameserverJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NameserverJsonMarshaller();
        }
        return instance;
    }
}

