/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class CancelJobRequestMarshaller
implements Marshaller<Request<CancelJobRequest>, CancelJobRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CancelJobRequest> marshall(CancelJobRequest cancelJobRequest) {
        if (cancelJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CancelJobRequest> request = new DefaultRequest<CancelJobRequest>(cancelJobRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2012-09-25/jobs/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", cancelJobRequest.getId() != null ? StringUtils.fromString(cancelJobRequest.getId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

