/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemSize;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class FileSystemSizeJsonMarshaller {
    private static FileSystemSizeJsonMarshaller instance;

    public void marshall(FileSystemSize fileSystemSize, StructuredJsonGenerator jsonGenerator) {
        if (fileSystemSize == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (fileSystemSize.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(fileSystemSize.getValue());
            }
            if (fileSystemSize.getTimestamp() != null) {
                jsonGenerator.writeFieldName("Timestamp").writeValue(fileSystemSize.getTimestamp());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FileSystemSizeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FileSystemSizeJsonMarshaller();
        }
        return instance;
    }
}

